/* eslint-disable @typescript-eslint/no-explicit-any */
/* eslint-disable @typescript-eslint/no-unsafe-function-type */

import {useRef, useEffect, useCallback} from 'react';
import PictureHuman from '@bddh/starling-dh-picture-client';
import type {PictureHumanType} from '@bddh/starling-dh-picture-client';
import axios from 'axios';

// 输入 appKey, appID 使用https://open.xiling.baidu.com/token-gen-tool.html生成 TOKEN
const TOKEN = '自行填写';

interface Events {
    [key: string]: Function[];
}

// 模拟接收流式音频，实际业务中并不需要
export class EventEmitter {
    private static instance: EventEmitter;
    private events: Events = {};

    private constructor() {}

    static getInstance(): EventEmitter {
        if (!EventEmitter.instance) {
            EventEmitter.instance = new EventEmitter();
        }
        return EventEmitter.instance;
    }

    on(eventName: string, cb: Function): void {
        if (!this.events[eventName]) {
            this.events[eventName] = [];
        }
        this.events[eventName].push(cb);
    }

    emit(eventName: string, ...args: any[]): void {
        if (!this.events[eventName]) {
            console.error(`No listeners set for event: ${eventName}`);
            return;
        }
        this.events[eventName].forEach((cb: Function) => {
            cb(...args);
        });
    }

    off(eventName: string, cb: Function): void {
        if (!this.events[eventName]) {
            console.error(`No listeners set for event: ${eventName}`);
            return;
        }
        this.events[eventName] = this.events[eventName].filter((listener: Function) => listener !== cb);
    }
}

// eslint-disable-next-line react-refresh/only-export-components
export async function fetchData(url: string): Promise<ArrayBuffer> {
    const response = await axios({
        url,
        method: 'GET',
        responseType: 'arraybuffer' // 设置响应类型为 arraybuffer
    });

    return response.data;
};

const Demo = () => {
    const instance = useRef<PictureHumanType>();
    const eventEmitterRef = useRef<any>();
    const hasUserGestureRef = useRef(true);

    const mockRequest = () => {
        return new Promise(res => {
            setTimeout(() => {
                console.log('request start')
                res(123);
            }, 2000);
        })
    }

    useEffect(() => {
        mockRequest().then(() => {
            console.log('request end')
            instance.current = new PictureHuman({
                modelUrl: 'https://facefusion-2021-peoplesdaily.bj.bcebos.com/track/picturefigure/people_CCZQPTWAS8MVGzQgZEDyKP_v1_shoubai.zip', // 需替换，自行填写
                licenseUrl: 'https://sdk-demo.bj.bcebos.com/xuniren-vis-20251104_0400.license', // 需替换，自行填写
                licenseKey: 'xuniren-vis-20251104_0400', // 需替换，自行填写
                statusCallback: (data: any) => {
                    console.info(JSON.stringify(data));
                    if (data?.code === 2001) {
                        hasUserGestureRef.current = false;
                    }
                    // 检测是否有用户交互行为，如果有，则可以进行有声开场白播报
                    if (data?.status?.value === 'SUCCESS') {
                        if (hasUserGestureRef.current) {
                            handleAudioCommand();
                            return;
                        }
                        console.warn('无用户点击行为，浏览器限制无法进行开场白播报');
                    }
                },
                canvasId: '#canvas-pic'
            });
        })
        // 使用事件监听触发的方式来模拟，使用方使用自己 tts流式获取音频流
        eventEmitterRef.current = EventEmitter.getInstance();

        eventEmitterRef.current.on('audioData', async (data: any) => {
            await instance.current?.audioRender(data);
        });
    }, []);

    // 流式音频进行驱动
    const handleAudioCommand = useCallback(async (interrupted: boolean = false) => {
        await instance.current?.stop();
        // const testUrl2 = 'https://star-light-lite.bj.bcebos.com/yinbintest/6min.pcm';
        const testUrl2 = 'https://star-light-lite.bj.bcebos.com/yinbintest/16k.pcm';
        const buffer = await fetchData(testUrl2);
        const unitLen = 2048; // 模拟切段
        const len = Math.ceil(buffer.byteLength / unitLen);
        for (let i = 0; i < len; ++i) {
            eventEmitterRef.current.emit('audioData', {
                audioBuffer: buffer.slice(i * unitLen, (i + 1) * unitLen),
                i,
                last: i === len - 1,
                first: i === 0,
                sample: 16000,
                interrupted: interrupted,
                finishListener: (res: any) => console.info('流式音频驱动完成', res)
            });
        }
    }, []);

    const handleTotalAudioCommand = useCallback(async (interrupted: boolean = false) => {
        // const testUrl2 = 'https://star-light-lite.bj.bcebos.com/yinbintest/6min.pcm';
        const testUrl2 = 'https://star-light-lite.bj.bcebos.com/yinbintest/16k.pcm';
        const buffer = await fetchData(testUrl2);
        await instance.current?.audioRender({
            audioBuffer: buffer,
            last: true,
            first: true,
            sample: 16000,
            interrupted: interrupted,
            finishListener: (res: any) => console.info('非流式音频驱动完成', res)
        });

    }, []);

    const handleTextCommand = useCallback((interrupted: boolean = false, last: boolean = true) => {
        instance.current?.textRender({
            msg: {
                token: TOKEN,
                // text: '使用文本，设置音色进行照片数字人的声音嘴型驱动，使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档',
                text: '大模型应用。一二三四五六七八九十，大模型应用。一二三四五六七八九十，',
                tts: {
                    per: 5116,
                    spd: 5,
                    pit: 5,
                    vol: 5
                },
                interrupted,
                last
            },
            finishListener: (res: any) => console.info('handleTextCommand finish', res)
        });
    }, []);

    const handleSteamPartTextCommand = useCallback((text: string, time: number) => {
        setTimeout(() => {
            instance.current?.textRender({
                msg: {
                    token: TOKEN,
                    text,
                    tts: {
                        per: 5116, // 自行填写替换
                        spd: 5,
                        pit: 5,
                        vol: 5
                    },
                    interrupted: false,
                    last: false
                },
                finishListener: (res: any) => console.info('handleTextCommand finish', res)
            });
        }, time);
    }, []);

    const handleSteamTextCommand = useCallback(() => {
        handleSteamPartTextCommand('大模型应用，第一次流式文本驱动，一', 0); // 第二个参数为延时时间
        handleSteamPartTextCommand('大模型应用，第二次流式文本驱动，一二', 30);
        handleSteamPartTextCommand('大模型应用，第三次流式文本驱动，一二三', 60);
        handleSteamPartTextCommand('大模型应用，第四次流式文本驱动，一二三四', 70);
        handleSteamPartTextCommand('大模型应用，第五次流式文本驱动，一二三四五', 100);
        handleSteamPartTextCommand('大模型应用，第六次流式文本驱动，一二三四五六', 130);

        // 这里是结尾last为true
        setTimeout(() => {
            instance.current?.textRender({
                msg: {
                    token: TOKEN,
                    // text: '使用文本，设置音色进行照片数字人的声音嘴型驱动，使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档使用文本，设置音色进行照片数字人的声音嘴型驱动，可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档可以设置是否打断正在播报的内容，token 的生成参考接口鉴权相关文档',
                    text: '大模型应用。一二三四五六七八九十，大模型应用。一二三四五六七八九十，',
                    tts: {
                        per: 5116,
                        spd: 5,
                        pit: 5,
                        vol: 5
                    },
                    interrupted: false,
                    last: true
                },
                finishListener: (res: any) => console.info('handleTextCommand finish', res)
            });
        }, 1600);
    }, [handleSteamPartTextCommand]);

    const checkPlay = useCallback(() => {
        const isPlay = instance.current?.isPlay();
        console.info('isPlay', isPlay);
    }, []);

    const play = () => instance.current?.play();

    const pause = () => instance.current?.pause();

    const over = () => instance.current?.stop();

    return (
        <div>
            <div style={{color: 'red'}}>直接驱动</div>
            <button onClick={() => handleAudioCommand(false)}>16k 流式音频驱动测试</button>
            <button onClick={() => handleTextCommand(false)}>单条文本驱动</button>
            <button onClick={() => handleSteamTextCommand()}>流式文本驱动</button>
            <div style={{color: 'red'}}>先终止/打断后驱动</div>
            <button onClick={() => handleTotalAudioCommand(true)}>16k 非流式（整段）音频驱动测试</button>
            <button onClick={() => handleTextCommand(true)}>文本驱动</button>
            <div style={{color: 'red'}}>状态及播放暂停指令</div>
            <button onClick={checkPlay}>检测是否正在播报, 查看 console</button>
            <button onClick={play}>播放</button>
            <button onClick={pause}>暂停</button>
            <button onClick={over}>终止/打断</button>
            <canvas id="canvas-pic" style={{maxHeight: '50vh'}}></canvas>
        </div>
    );

};

export default Demo;


