/**
 * @file demo/app/index
 * @author sunwen05
 */

Page({
	data: {
    isAppVisible: true,
		inputText: '你好，我是数字人，很高兴被你进行文本驱动',
		digitalHumanSetting: {
      // websocketUrl: 'wss://persona.baidu.com:8850/cloud//digital-human-demonstration',
			token: '', // 自行填写
			figureId: 'A2A_V2-xinxin', // 自行填写
			mode: 'noAudio',
			ttsPer: '5137', // 自行填写
			ttsPitch: 5,
			cameraId: 3,
			backgroundImageUrl: 'https://digital-human-js-cdn.cdn.bcebos.com/web_base/20240118200843/digital-human-web-new-base/img/login-bg-new.png',
			resolutionWidth: 720,
			resolutionHeight: 1280,
			x: 0, // 自行填写
			y: 0, // 自行填写
			z: 1 // 自行填写
		}
	},
	onLoad(options) {
		this.digitalhuman = this.selectComponent('#digitalhuman');
		console.log('digitalhuman', this.digitalhuman);
		this.digitalhuman.setLogLevel(this.digitalhuman.LOG_LEVEL.VERBOSE);
		const params = JSON.parse(options.params || '{}');
		this.setData({
			digitalHumanSetting: {
				...this.data.digitalHumanSetting,
				...params,
				...options
			}
		});
	},
	onUnload() {
		this.digitalhuman.destroy();
	},
	onMessage(message = {}) {
    console.log('message', message.detail);
    if (message.detail.action === 'DISCONNECT_ALERT') {
      console.log('数字人马上消失，进行交互唤醒数字人');
    }
    if (message.detail.action === 'TIMEOUT_EXIT') {
      this.handleDestroy();
    }
	},
	onStateChange(e) {
		const {
			type,
			error = {},
			loading
		} = e.detail;
		const {
			action,
			message,
			code
		} = error;
		if (type === 'INIT') {
			// 通过监听 INIT 消息，来实现数字人的开场白设置
			this.digitalhuman.textRender({
				body: '数字人初始化完成，这是数字人的开场白播报，可以自行修改开场白内容',
				requestId: this.digitalhuman.getUuid()
			});
		}
		if (type === 'ERROR' && action === 'CONNECT') {
			wx.showModal({
				title: '提示',
				content: `${message}，code${code}`,
				success: () => {
					wx.navigateBack();
				}
			});
		}
		// 判断视频流是否 ready
		if (type === 'LOADING') {
			console.log('LOADING', loading);
		}
	},
	handleDestroy() {
    this.digitalhuman.destroy();
    this.setData({
      isAppVisible: false
    });
	},
	handleInput(e) {
		this.setData({
			inputText: e.detail.value
		});
	},
	handleSend() {
		this.digitalhuman.textRender({
			body: this.data.inputText,
			requestId: this.digitalhuman.getUuid()
		});
	},
	handlePause() {
		// 近端音视频暂停，远端并未暂停
		this.digitalhuman.pause(true);
	},
	handleMute() {
		this.digitalhuman.mediaMute(true);
	},
	handleInterrupt() {
		this.digitalhuman.textRender({
			body: '<interrupt></interrupt>',
			requestId: this.digitalhuman.getUuid()
		});
	},
	handlePlay() {
		// 恢复近端音视频流为远端最新实时流
		this.digitalhuman.pause(false);
	},
	handleUnMute() {
		this.digitalhuman.mediaMute(false);
	},
});