/* eslint-disable @typescript-eslint/no-explicit-any */
/**
 * @file paas ar Demo
 * @author zhangyue49
 */
import {useEffect, useCallback, useState, useRef} from 'react';
import {DHIframeV2} from '@bddh/starling-dhiframe';
import './App.css';

const dhIframe = new DHIframeV2('demo');

function splitArrayBuffer(arrayBuffer: ArrayBuffer, chunkSize: number) {
    const chunks: ArrayBuffer[] = [];
    for (let i = 0; i < arrayBuffer.byteLength; i += chunkSize) {
        const end = Math.min(i + chunkSize, arrayBuffer.byteLength);
        chunks.push(arrayBuffer.slice(i, end));
    }
    return chunks;
}
const Demo = () => {
    const [show, setShow] = useState(false);
    const [animojis, setAnimojis] = useState<string[]>();

    const inputRef = useRef<any>();

    const handleRender = useCallback((welcome?: string) => {
        const text = welcome || inputRef.current?.value || '空文本测试';
        dhIframe?.textRender?.(
            {
                token: '请自行填写token',
                text,
                // requestId: '可传入自定义唯一标识',
                tts: {
                    per: '请自行填写',
                    spd: 5,
                    pit: 5
                }
            },
            ({status, data}: {status: string, data: any}) => {
                console.log('textRender callback:', status, data);
            });
    }, []);

    const handleDestroy = useCallback(() => {
        if (!show) {
            setShow(true);
        }
        else {
            dhIframe.destroy();
        }
    }, [show]);

    const handleInterrupt = useCallback(() => {
        dhIframe?.sendMessage('INTERRUPT', {});
    }, []);

    const handleAudioRender = useCallback((file: File) => {
        if (!file) {
            return;
        }
        // 使用 FileReader 读取文件内容
        const reader = new FileReader();
        // 监听文件加载完成事件
        reader.onload = function (loadEvent) {
            const arrayBuffer: ArrayBuffer = loadEvent?.target?.result as ArrayBuffer;
            const chunks: ArrayBuffer[] | null = splitArrayBuffer(arrayBuffer, 1024 * 2);
            chunks.map(chunk => {
                let audioData: ArrayBuffer | null = new Int16Array(chunk);
                dhIframe.audioRender(audioData);
                audioData = null;
            });

            dhIframe?.stopAudioRender();

        };
        reader.readAsArrayBuffer(file);
    }, []);

    const handleUploadAudio = useCallback(async (event: any) => {
        dhIframe?.startAudioRender(
            '自行填写token',
            ({status, data}: {status: string, data: any}) => {
                console.log('audioRender callback', status, data);
                if (status === 'AUDIO_INIT') {
                    const file = event.target.files[0];
                    handleAudioRender(file);
                }
            });
    }, [handleAudioRender]);

    const handleAddAnimoji = useCallback((id: string) => {
        dhIframe.animojiRender(id);
    }, []);

    const handleCustom = useCallback(() => {
        // 做动作
        dhIframe.animojiRender('expression1', (data: object) => {
            console.log(data, 'finish')
        });
        // dhIframe.changeParts([
        //     {
        //         type: "hair",
        //         id: "coco_02_hair_out"
        //     },
        //     {
        //         type: "badge",
        //         id: "coco_02_badge_out"
        //     },
        //     {
        //         type: "shoes",
        //         id: "coco_02_shoes_out"
        //     },
        //     {
        //         type: "body",
        //         id: "coco_02_body_out"
        //     },
        // ]);
    }, []);

    useEffect(() => {
        dhIframe.registerMessageReceived((data: any) => {
            console.log('global:', data);
            if (data.type === 'state') {
                if (data.content.status === 'INIT') {
                    dhIframe.load({
                        backgroundImageUrl: '',
                        modelUrl: 'https://sdk-demo.bj.bcebos.com/yuki_h5_250206.zip',
                        cameraId: 'h_full_cam'
                    });
                }
                if (data.content.status === 'AVATAR_LOAD') {
                    setAnimojis(data.content?.message?.config?.animationList.map((item: any) => item.animationName));
                    handleRender('数字人开场白');
                }
                if (data.content.status === 'USER_ACTIVE') {
                    console.info('模型加载完成无用户交互');
                }
                if (data.content.status === 'AUTHENTICATION') {
                    console.log('AUTHENTICATION callback:', data);
                }
                if (data.content.status === 'CLOSE') {
                    setShow(false);
                }
            }
        });
        return () => {
            dhIframe.removeMessageReceived();
        };
    }, [handleRender]);

    useEffect(() => {
        setTimeout(() => {setShow(true)}, 3000)
    }, [])

    return (
        <div className="ar-player-wrapper">
            <div>鉴权文件，只支持本地域名，不可以使用ip预览，否则鉴权不通过，人像无法加载</div>
            {show && (
                <iframe
                    id="demo"
                    src="https://open.xiling.baidu.com/cloud/client/ar?platform=paas&licenseUrl=https://sdk-demo.bj.bcebos.com/xuniren_20260206_0395.license&licenseKey=xuniren_20260206_0395"
                    allow="autoplay;"
                    style={{width: '100vw', height: '100vh'}}
                >
                </iframe>
            )}
            <div className="ar-play-area">
                <div>未填写token,无法正常进行驱动</div>
                <div className="box">
                    <textarea ref={inputRef} className="input-box"></textarea>
                    <button onClick={() => handleRender()}>驱动</button>
                </div>
                <div className="box">
                    <h4>音频文件解码 16k 单通道pcm文件</h4>
                    <input type="file" onChange={handleUploadAudio} accept=".pcm" />
                </div>
                <div className="box">
                    <h4>命令</h4>
                    <button onClick={() => handleInterrupt()} className="btn">打断</button>
                    <button onClick={handleDestroy} className="btn">销毁</button>
                    <button onClick={() => window.location.reload()} className="btn">load</button>
                    <button onClick={handleCustom}>自定义切换</button>
                </div>
                <div className="box">
                    <h4>切换相机位，参考人像包config.json文件，部分人像不支持如下机位</h4>
                    <button onClick={() => dhIframe.changeCamera('h_full_cam')} className="btn">全身</button>
                    <button onClick={() => dhIframe.changeCamera('h_half_cam')} className="btn">半身</button>
                    <button onClick={() => dhIframe.changeCamera('h_face_cam')} className="btn">人脸</button>
                    <button onClick={() => dhIframe.changeCamera('h_shoulder_cam')} className="btn">肩位</button>
                </div>
                <div className="box">
                    {animojis?.length && (
                        <div>
                            <h4>切换动画</h4>
                            {animojis.map(animoji => (
                                <button onClick={() => handleAddAnimoji(animoji)} key={animoji}>{animoji}</button>
                            ))}
                        </div>
                    )}
                </div>
            </div>
        </div>
    );
};


export default Demo;